<?php
// Include the main TCPDF library (search for installation path).
require_once('../TCPDF-main/tcpdf.php');
//include('../app/config.php');
//include('../class/classconexion.php');




// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, array(79,80), true, 'UTF-8', false);

// set document information
$pdf->setCreator(PDF_CREATOR);
$pdf->setAuthor('Nicola Asuni');
$pdf->setTitle('TICKET DE COCINA');
$pdf->setSubject('TCPDF Tutorial');
$pdf->setKeywords('TCPDF, PDF, example, test, guide');



// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set default monospaced font
$pdf->setDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->setMargins(5, 5, 5);

// set auto page breaks
$pdf->setAutoPageBreak(true, 5);


// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}



########################## FUNCION TICKET COMANDA ##############################
function TicketComanda()
{  

    $tra = new Login();
    $reg = $tra->DetallesPedidoComanda();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
  
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "./fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 14, 4, 50, 12, "PNG");
    $this->Ln(6);

    }

    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',12);
    $pdf->SetFillColor(2,157,116);
    $pdf->Cell(66, 5, "TICKET DE COCINA", 0, 0, 'C');
    $pdf->Ln(5);
  
    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',10);
    $pdf->CellFitSpace(66,4,utf8_decode($reg[0]['nomsucursal']), 0, 1, 'C');
    $pdf->Ln(2);
    
    $pdf->SetX(2);
    $pdf->SetFont('Courier','B',12);
    $pdf->Cell(70,3,'--------------------------',0,0,'C');
    $pdf->Ln(3);

    if($reg[0]['tipopedido'] == 1){

    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',10);
    $pdf->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $pdf->SetFont('Courier','B',13);
    $pdf->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(16,3,"SALA:",0,0,'L');
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(50,3,utf8_decode($reg[0]['nomsala']),0,1,'L');

    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(16,3,"Nº MESA:",0,0,'L');
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(50,3,portales(utf8_decode($reg[0]['nommesa'])),0,1,'L');

    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(16,3,"MESERO:",0,0,'L');
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(50,3,utf8_decode($reg[0]['nombre_mesero']),0,1,'L');
    
    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');

    } else {

    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',10);
    $pdf->CellFitSpace(24,3,"Nº PEDIDO:",0,0,'L');
    $pdf->SetFont('Courier','B',13);
    $pdf->CellFitSpace(42,3,utf8_decode($reg[0]['numpedido']),0,1,'L');

    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(12,3,"CAJERO:",0,0,'L');
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(54,3,utf8_decode($reg[0]['nombres']),0,1,'L');
    
    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(26,3,"FECHA EMISIÓN:",0,0,'L');
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(40,3,date("d-m-Y H:i:s",time()),0,1,'L');
    
    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(26,3,"TIPO DE PEDIDO:",0,0,'L');
    $pdf->SetFont('Courier','B',8);
    $pdf->CellFitSpace(40,3,$tipo = ($reg[0]['repartidor'] == 0 ? "EN LOCAL" : "A DOMICILIO"),0,1,'L');
  
    }


    $pdf->SetX(2);
    $pdf->SetFont('Courier','B',12);
    $pdf->Cell(70,3,'--------------------------',0,0,'C');
    $pdf->Ln(3);

    $pdf->SetX(4);
    $pdf->SetFont('Courier','B',8);
    $pdf->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $pdf->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $pdf->Cell(10,3,'CANT',0,0,'C');
    $pdf->Cell(56,3,'DESCRIPCIÓN DE PRODUCTO',0,1,'C');

    $pdf->SetX(2);
    $pdf->SetFont('Courier','B',12);
    $pdf->Cell(70,3,'--------------------------',0,0,'C');
    $pdf->Ln(3);

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){


    $pdf->SetX(4);
    $pdf->SetFillColor(192);
    $pdf->SetDrawColor(3,3,3);
    $pdf->SetLineWidth(.2);
    $pdf->SetFont('Courier','B',12);  
    $pdf->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $pdf->Cell(10,3,utf8_decode(number_format($reg[$i]['cantventa'], 2, '.', ',')),0,0,'L');
    $pdf->Cell(56,3,portales(utf8_decode(getSubString($reg[$i]["producto"], 32))),0,0,'L');


//OBSERVACIONES MANUALES


    if($reg[$i]['observacionespedido'] != ""){ 
    $pdf->Ln();
    $pdf->SetX(14);
    $pdf->SetFont('Courier','B',30);
    $pdf->MultiCell(56,2,portales(utf8_decode($reg[$i]['observacionespedido'] == '' ? "" : "(".$reg[$i]['observacionespedido'].")")),0,'J');
    $pdf->Ln();
    }

    if($reg[$i]['salsaspedido'] != ""){ 
    $pdf->Ln();
    $pdf->SetX(14);
    $pdf->SetFont('Courier','B',6);
    $pdf->MultiCell(56,2,portales(utf8_decode($reg[$i]['salsaspedido'] == '' ? "" : "(".str_replace("_", " ", $reg[$i]['salsaspedido']).")")),0,'J');
    }

    $pdf->Ln();  
    }

    if($reg[0]['descripciones'] != ""){ 
    $pdf->Ln();
    $pdf->SetX(3);
    $pdf->SetFont('Courier','B',6);
    $pdf->MultiCell(66,2,portales(utf8_decode($reg[0]['descripciones'] == '' ? "" : $reg[0]['descripciones'])),0,'J');
    }

    $pdf->Ln(3);
    $pdf->SetX(2);
    $pdf->SetFont('Courier','B',12);
    $pdf->Cell(70,0.5,'--------------------------',0,1,'C');
    $pdf->SetX(2);
    $pdf->Cell(70,0.5,'--------------------------',0,1,'C');
    $pdf->Ln(3);
}
########################## FUNCION TICKET COMANDA ##############################






    // Datos de conexión a la base de datos
    
$servername = "velizia.changsha88.com.ve";
$username = "cursosdesushi_velizia";
$password = "Osito1852570.";
$dbname = "cursosdesushi_velizia_multisucursal";

// Crear conexión
$conn = mysqli_connect($servername, $username, $password, $dbname);

// Verificar conexión
if (!$conn) {
    die("Conexión fallida: " . mysqli_connect_error());
}

// Consulta SQL
//$sql = "SELECT idproducto FROM productos";
//$result = mysqli_query($conn, $sql);


//$sql= "SELECT codproducto,idproducto FROM productos";
//$result = mysqli_query($conn, $sql);

/*
"SELECT *
FROM mesas
INNER JOIN salas
ON mesa.statusmesa = nomsala


";


*/


$sql = "SELECT nommesa FROM mesas";
$result = mysqli_query($conn, $sql);

$html = '<table>
<thead>
<tr>
<th>mesa</th>
</tr>
</thead>
<tbody>';

if (mysqli_num_rows($result) > 0) {
    // Imprimir cada fila de datos
    while($row = mysqli_fetch_assoc($result)) {
        $html .= '<tr>
<td>'.$row["nommesa"].'</td>
</tr>';


    }
} else {
    $html .= '<tr><td colspan="3">No se encontraron resultados</td></tr>';
}

$html .= '</tbody></table>';

$pdf->writeHTML($html, true, false, true, false, '');

// Cerrar conexión a la base de datos
mysqli_close($conn);

// Salida del PDF al navegador
$pdf->Output('reporteCocina.pdf', 'I');
?>




